package com.wissamfawaz;

public class ArrayBasedQueue implements Queue {
    private Object[] array;
    private int front, rear, size;
    private StringBuilder sb;

    public ArrayBasedQueue(int capacity) {
        array = new Object[capacity];
        front = rear = size = 0;
        sb = new StringBuilder();
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public boolean isEmpty() {
        return size == 0;
    }

    @Override
    public void enqueue(Object element) throws QueueException {
        if (size == array.length) {
            throw new QueueException("Queue is full!");
        }
        array[rear] = element;
        rear = (rear + 1) % array.length;
        size++;
        sb.append(element + " ");
    }

    @Override
    public Object dequeue() throws QueueException {
        if (isEmpty()) {
            throw new QueueException("Queue is empty!");
        }

        Object toReturn = array[front];
        array[front] = null;
        front = (front + 1) % array.length;

        size--;
        sb.delete(0, toReturn.toString().length() + 1);

        return toReturn;
    }

    @Override
    public Object front() throws QueueException {
        if (isEmpty()) {
            throw new QueueException("Queue is empty!");
        }
        return array[front];
    }

    @Override
    public String toString() {
        return sb.toString();
    }

}
